﻿/*
USAGE:
	showPreview = function( preview_obj ){}// showPreview()
	
	#include "functions/loadLevelPreviews.as"
	getPreviews = function( _this )
	{
		if(!_this.previewObj)
			_this.previewObj = _this.loadLevelPreviews( _this, "previewLoader", 0 );
		_this.previewObj.addListener( _this );
		_this.previewObj.catchUp();
	}// getPreviews()
	setTimeout( getPreviews, 1, this );
	
	onUnload = function(){
		previewObj.removeListener( this );
	}// onUnload()

EVENTS:
	showPreview( preview_obj )
	onAllPreviewsLoaded( previewList )
*/
#include "functions/map.as"
#include "functions/readXml.as"
loadLevelPreviews = function( _this, newName, newDepth )
{
	var _this = _this || this;
	var newDepth = (newDepth!=undefined) ? newDepth : nextDepth(_this);
	var newName = newName || "levelLoader_"+newDepth;
	var levelLoader = _this.createEmptyMovieClip( newName, newDepth );
	levelLoader._visible = false;
	levelLoader.appPath = mdm.Application.path;
	levelLoader.previewList = [];
	levelLoader.loadIndex = 0;
	levelLoader.previewsLoaded = 0;
	AsBroadcaster.initialize( levelLoader );
	
	
	
	// make a list of all levels
	levelLoader.addLevel = function( path )
	{
		var newLevel = {
			path:path,
			image:null,
			width:null,
			height:null,
			collision:null
		}
		levelLoader.previewList.push( newLevel );
	}// addLevel()
	
	
	
	levelLoader.getLevels = function( path )
	{
		// add files in this folder
		var fileList = mdm.FileSystem.getFileList( (levelLoader.appPath+path), "*.lvl");
		for(var fi=0; fi<fileList.length; fi++)
			levelLoader.addLevel( path+fileList[fi] );
		// add files in sub-folders
		var folderList = mdm.FileSystem.getFolderList( levelLoader.appPath+path );
		for(var fo=0; fo<folderList.length; fo++)
			levelLoader.getLevels( path+folderList[fo]+"\\" );
	}// getLevels()
	levelLoader.getLevels("levels\\");
	
	
	
	levelLoader.loadNextLevel = function()
	{
		if(levelLoader.previewList.length > 0)
		{// if:  previewList is populated
			// get level path to load
			var output_obj = levelLoader.previewList[levelLoader.loadIndex];
			var path = output_obj.path;
			// add a map to this movieClip
			var newDepth = nextDepth(levelLoader);
			var newName = "map_"+newDepth;
			// create this level's map
			var thisMap = makeMap( newName, levelLoader, newDepth );
			XML.prototype.ignoreWhite = true;
			var level_xml = new XML();
			// after this map finishes drawing
			thisMap.output_obj = output_obj;
			thisMap.onLoad = function()
			{// map finishes drawing()
				var output_obj = this.output_obj;
				// take a picture of it
				var imageWidth = this.width *16;
				var imageHeight = this.height *16;
				var output_pic = new flash.display.BitmapData( imageWidth, imageHeight, false, 0 );
				output_pic.draw( this );
				// store the picture
				output_obj.image = output_pic;
				output_obj.width = this.width;
				output_obj.height = this.height;
				output_obj.collision = this.collision_array;
				// prepare to load the next level
				levelLoader.previewsLoaded++;
				// fire an event
				levelLoader.broadcastMessage("showPreview", output_obj);
				if(levelLoader.previewsLoaded == levelLoader.previewList.length)
					levelLoader.broadcastMessage("onAllPreviewsLoaded", levelLoader.previewList);
				// remove this map
				this.removeMovieClip();
			}// map finishes drawing()
			// after the level XML loads
			level_xml.map = thisMap;
			level_xml.onLoad = function( success )
			{
				if(success)
				{// if:  success
					// convert data
					var levelData = {};
					readXml( level_xml.firstChild, levelData );
					// pass map data to the map system
					level_xml.map.drawObj( levelData.level.map );
				}// if:  success
			}// level_xml.onLoad()
			// load the level XML
			level_xml.load( path );
			levelLoader.loadIndex++;
			if(levelLoader.loadIndex == levelLoader.previewList.length)
				levelLoader.onEnterFrame = null;
		}// if:  previewList is populated
	}// loadNextLevel()
	if(levelLoader.previewList.length > 0)
		levelLoader.onEnterFrame = levelLoader.loadNextLevel;
	
	
	
	levelLoader.catchUp = function()
	{
		if(	levelLoader.previewsLoaded > 0 )
		{// if:  previewsLoaded > 0
			for(var i=0; i<levelLoader.previewsLoaded; i++)
			{
				var thisPreview = levelLoader.previewList[i];
				levelLoader.broadcastMessage("showPreview", thisPreview);
			}// for:  previewsLoaded
			if(levelLoader.previewsLoaded == levelLoader.previewList.length)
				levelLoader.broadcastMessage("onAllPreviewsLoaded", levelLoader.previewList);
		}// if:  previewsLoaded > 0
	}// catchUp()
	
	
	
	levelLoader.getPreviewData = function( levelPath )
	{
		for(var i=0; i<levelLoader.previewList.length; i++)
		{// for:  all loaded levels
			if(levelLoader.previewList[i].path == levelPath)
			{// if:  level data found
				var output = levelLoader.previewList[i];
				break;
			}// if:  level data found
		}// for:  all loaded levels
		return output;
	}// getPreviewData()
	
	
	
	levelLoader.onUnload = function()
	{
		// remove listeners
		for(var i=levelLoader._listeners.length-1; i>=0; i--)
			levelLoader.removeListener( levelLoader._listeners[i] );
	}// onUnload()
	
	
	
	return levelLoader;
}// loadLevelPreviews()